#!/bin/bash
#
#VERSION=6
#CHANGES="extra info for current fw version"
IMAGE_URL=`echo $1 |sed 's/\/*$//'`
OPTION="$2"
BLOCKLIST="7 6 5"


FLASH_CONFIG_STORAGE=/usr/conf/flash_update
FLASH_LOG=/usr/conf/flash.log
FLASH_LOG_OLD=/usr/conf/flash.log.old
CHROOT_DIR=/tmp/mchroot/
FLASH_LOCK=/tmp/flash.lock

declare check_md5sums=array
declare mtdblock_md5sums=array


function check_blocksize {
	xblock=$1
	xsize=$2
	
	#if we get passed the size as parameter, don't get it from file
	if [[ -n "$xsize" ]]; then
		size="$xsize"
	else
		[[ ! -f /tmp/$block ]] && { error=1; return; }
		size=$(ls -l /tmp/$block|awk '{print $5}')
	fi
	
	error=0
	case $xblock in
		mtdblock8)
			if [ $size -ne 3801088 ]; then
				error=1
				echo "<br>$xblock size wrong: expected 3801088, got $size"
			fi
		;;
		mtdblock7)
			if [ $size -ne 8388608 ]; then
				error=1
				echo "<br>$xblock size wrong: expected 8388608, got $size"
			fi
		;;
		mtdblock6)
			if [ $size -ne 10485760 ]; then
				error=1
				echo "<br>$xblock size wrong: expected 10485760, got $size"
			fi
		;;
		mtdblock5)
			if [ $size -ne 6291456 ]; then
				error=1
				echo "<br>$xblock size wrong: expected 6291456, got $size"
			fi
		;;
		*)
			echo "<br>check_blocksize: unexpected parameter<br>"
			error=1
		;;
	esac
}


function check_image_download {
	#test download all needed blocks and check their size
	cd /tmp/
	FAILED=0
	echo "<h2> Checking availability and integrity of image files!</h2><br>"
	for _block in $BLOCKLIST; do
		block=mtdblock$_block
	# 	echo wget $IMAGE_URL/$block -O /tmp/$block "<br>"
		echo "checking: $IMAGE_URL/$block<br>"
		wget $IMAGE_URL/$block -O /tmp/$block &> /dev/null
		if [[ $? != 0 ]]; then
			echo "<h2><font color='red'>Downloading image</font></h2><br>"
			echo "<h3> $IMAGE_URL/$block </h3><br>"
			echo "<h2><font color='red'>failed!</font></h2><br>"
			echo "<h2><font color='brown'>Cancelled firmware flashing! Please check your network connectivity!</font></h2>"
			FAILED=1
		
		else
			#we could successfully downloads
			check_blocksize $block
			if [ $error != 0 ]; then
				echo "<h2><font color='red'>Downloaded image</font></h2><br>"
				echo "<h2> $IMAGE_URL/$block </h2><br>"
				echo "<h2><font color='red'>has wrong size!</font></h2><br>"
				echo "<h2><font color='brown'>Cancelled firmware flashing! Please check your image integrity!</font></h2>"
				FAILED=1
			fi
			
			wget $IMAGE_URL/$block.md5 -O /tmp/$block.md5sum.1 &> /dev/null
			if [[ $? = 0 ]]; then
				file_md5sum=`head -1 /tmp/$block.md5sum.1|sed 's/ .*//'`
				block_md5sum=`md5sum /tmp/$block|sed 's/ .*//'`
				
				if [ x"$file_md5sum" != x"$block_md5sum" ]; then
					echo "<h2><font color='red'>Downloaded image</font></h2><br>"
					echo "<h2> $IMAGE_URL/$block </h2><br>"
					echo "<h2><font color='red'>has wrong md5sum $file_md5sum!<br>Expected $block_md5sum!</font></h2><br>"
					echo "<h2><font color='brown'>Cancelled firmware flashing! Please check your image integrity!</font></h2><br>"
					FAILED=1
				fi
				echo "md5sum: $file_md5sum matches<br>"
			else
	# 			echo "no md5sum check<br>"
				echo "<h2><font color='red'>Downloaded image</font></h2><br>"
				echo "<h2> $IMAGE_URL/$block </h2><br>"
				echo "<h2><font color='red'>has no md5sum file!</font></h2><br>"
				echo "<h2><font color='brown'>Cancelled firmware flashing! Please check your image integrity!</font></h2><br>"
				FAILED=1
			fi
			
		fi
		rm -f /tmp/$block
		[[ $FAILED = 1 ]] && exit 1
		echo "<br>Succesfully downloaded $block <br>------------------------------------------------------------------------<br><br>"
	done
}

function check_flash_tar_gz {

	echo "Checking archive:<br>"
	for _block in $BLOCKLIST; do
		mtdblock=mtdblock$_block
		
		size=`tar xOzf $TARNAME $mtdblock|wc -c`
		check_blocksize $mtdblock $size
		if [[ $error = 1 ]]; then
			echo "unexpected filesize $size for $mtdblock,<br>"
			exit 1
		fi

		echo "checking md5sum of $mtdblock <br>"
		check_md5sums[$_block]=`tar xOzf $TARNAME $mtdblock.md5 |head -1|sed 's/ .*//'`
		mtdblock_md5sums[$_block]=`tar xOzf $TARNAME $mtdblock | md5sum | sed 's/ .*//'`
		
		if [[ -n ${check_md5sums[$_block]} && ${check_md5sums[$_block]} == ${mtdblock_md5sums[$_block]} ]]; then
			echo "md5sum in archive for $mtdblock matches "${check_md5sums[_block]}" <br>"
		else
			echo "md5sum in archive for $mtdblock doesn't match, cancelling!<br>"
			exit 1;
		fi
		echo "==========================================<br>"
	done
}


function create_mchroot_environment {
	
	#set flag that we started the flash process
	#it prevents a second call to this script
	touch $FLASH_LOCK
	
	#prepare the chroot environment folders
	if [ ! -d $CHROOT_DIR/dev ]; then
		mkdir -p $CHROOT_DIR
		mkdir -p $CHROOT_DIR/dev/
		mkdir -p $CHROOT_DIR/proc/
		mkdir -p $CHROOT_DIR/sys/
		mkdir -p $CHROOT_DIR/usr/conf/
		mkdir -p $CHROOT_DIR/tmp/
		mkdir -p $CHROOT_DIR/extra/
	fi
	
	cd $CHROOT_DIR
	
	export PATH=/extra/:$PATH
	#copy the necessary binaries to the chroot environment
	if [ ! -f $CHROOT_DIR/bin/busybox ]; then
		cp -ar /bin $CHROOT_DIR/
		cp -ar /sbin $CHROOT_DIR/
		cp -ar /lib $CHROOT_DIR/
		cp -ar /etc $CHROOT_DIR/
		cp -ar /usr/bin/awk $CHROOT_DIR/bin/
		
		ln -s ../bin/busybox $CHROOT_DIR/extra/md5sum
		ln -s ../bin/busybox $CHROOT_DIR/extra/wget
		ln -s ../bin/busybox $CHROOT_DIR/extra/head
		ln -s ../bin/busybox $CHROOT_DIR/extra/tee
		ln -s ../bin/busybox $CHROOT_DIR/extra/which
		ln -s ../bin/busybox $CHROOT_DIR/extra/killall
	fi
	
	#bind the system directories and /usr/conf into the chroot directory
	if [ ! -e $CHROOT_DIR/dev/mtdblock5 ]; then
		mount -o bind /dev/ $CHROOT_DIR/dev/
		mount -o bind /sys/ $CHROOT_DIR/sys/
		mount -o bind /proc/ $CHROOT_DIR/proc/
		mount -o bind /usr/conf/ $CHROOT_DIR/usr/conf/
	fi
	
	rm -rf $FLASH_CONFIG_STORAGE.old
	mkdir $FLASH_CONFIG_STORAGE
	
	cp -p /etc/passwd $FLASH_CONFIG_STORAGE
	cp -p /etc/shadow $FLASH_CONFIG_STORAGE
	cp -p /etc/shadow- $FLASH_CONFIG_STORAGE
	cp -p /etc/hostname.default $FLASH_CONFIG_STORAGE
	cp -p /etc/hostname.default $FLASH_CONFIG_STORAGE
	cp -rp /root $FLASH_CONFIG_STORAGE
	
	
	#prepare the chroot environment
	export -f check_blocksize
	
	[[ -f "$FLASH_LOG" ]] && { \mv "$FLASH_LOG" "$FLASH_LOG_OLD"; }
	echo Starting flash process: `date` >> $FLASH_LOG
}


########################################################################################################################
########################################################################################################################
########################################################################################################################
########################################################################################################################

CHECKBOOTMODE=1
CLEANLOGS=0
if [ "$OPTION" = force ]; then
	CHECKBOOTMODE=0
elif [ "$OPTION" = clean ]; then
	CLEANLOGS=1
elif [ "$OPTION" = forceclean ]; then
	CHECKBOOTMODE=0
	CLEANLOGS=1
fi

#check or failed attempt
if [[ -f $FLASH_LOCK ]]; then
	echo "<h2>Failed flash process detected! You need to reboot before starting another attempt!</h2><br>"
	echo "<h2><font color='red'>Cancelled firmware flashing!</font></h2><br>"
	exit 1
fi

if [ $CLEANLOGS = 1 ]; then
	rm -f /tmp/*.log /tmp/*.log.1
fi

if [ $CHECKBOOTMODE = 1 ]; then
	#check if we are in update mode
	FWSTATE=`beroconf get root boot_fwupdate`
	if [ x"$FWSTATE" != x1 ]; then
		echo "<h1><font color='red'>Device must be in update mode!</font></h1><br>"
		exit 1
	fi
fi

#check syntax
USE_IMAGE_FILES=0
USE_TAR_GZ=0
RETRIEVE_TAR_GZ=0


echo $IMAGE_URL|grep '^http' &> /dev/null
if [[ $? == 0 ]]; then
	echo $IMAGE_URL|grep '.tar.gz$' &> /dev/null
	if [[ $? = 0 ]]; then
		RETRIEVE_TAR_GZ=1
		USE_TAR_GZ=1
	else
		USE_IMAGE_FILES=1
		check_image_download
	fi
else
	echo "checking $CHROOT_DIR/tmp/$IMAGE_URL<br>" | tee -a $FLASH_LOG
	if [ -f $CHROOT_DIR/tmp/$IMAGE_URL ]; then
		USE_TAR_GZ=1
	else
		echo "$CHROOT_DIR/tmp/$IMAGE_URL does not exist<br>"  | tee -a $FLASH_LOG
		exit 1
	fi
fi

# echo USE_IMAGE_FILES $USE_IMAGE_FILES
# echo USE_TAR_GZ $USE_TAR_GZ
# echo RETRIEVE_TAR_GZ $RETRIEVE_TAR_GZ

if [[ ! $USE_TAR_GZ && ! $USE_IMAGE_FILES ]]; then
	echo "<h2>ddflash.sh cancelled!</h2><br>"
	exit 1
fi

if [ $RETRIEVE_TAR_GZ = 1 ]; then
	echo "Fetching $IMAGE_URL <br>"
	OUT=`echo $IMAGE_URL|sed 's/.*\///'`
	TARNAME=$CHROOT_DIR/tmp/$OUT
	TARNAME_CHROOT=/tmp/$OUT
	
	wget $IMAGE_URL -O $TARNAME &> /dev/null
	if [[ $? != 0 ]]; then
		echo "Fetching $IMAGE_URL failed!<br>"
		rm -f $CHROOT_DIR/tmp/$OUT
		exit 1
	fi
elif [[ $USE_TAR_GZ = 1 ]]; then
	OUT=`echo $IMAGE_URL|sed 's/.*\///'`
	TARNAME=$CHROOT_DIR/tmp/$OUT
	TARNAME_CHROOT=/tmp/$OUT
	if [[ ! -f "$TARNAME" ]]; then
		echo "$IMAGE_URL not in directory!<br>"
		exit 1
	fi
fi



# MAYBE TODO
# lighttpd, remotesupport.sh, netconfig server and sshd are still running
# this could be moved too into the chroot environment

echo "<h1><font color='red'>Do not turn off the device!</font></h1>"

#####################################################################
#####################################################################
## here the actual flashing starts
## all necessary binaries are copied into a folder under tmp
## then the script chroots into this folder
## fetches the image for mtdblock7 and writes it to the flash
## then it does it for mtdblock6 and mtdblock5 too and reboots

#####################################################################
#####################################################################

echo "<h1><font color='blue'>Flashing now!</font></h1>";
echo "<h1><font color='blue'>Please wait for the process to finish.</font></h1><br>";


#stop the crond, we don't want any unforeseen actions
/etc/init.d/S*cron stop &> /dev/null
killall -9 crond &> /dev/null
mount -o remount,ro /
killall -9 jffs2_gcd_mtd5
killall -9 jffs2_gcd_mtd6
killall -9 jffs2_gcd_mtd7

#####################################################################
#####################################################################
##### TAR.GZ method
#####################################################################
#####################################################################


CURRENT_FIRMWARE=UNKNOWN
if [[ -f /usr/local/FILENAME ]]; then
	CURRENT_FIRMWARE=$(head -1 /usr/local/FILENAME)
fi
echo "Current FW: $CURRENT_FIRMWARE" | tee -a $FLASH_LOG

if [[ $USE_TAR_GZ = 1 ]]; then

create_mchroot_environment
check_flash_tar_gz

/usr/sbin/chroot $CHROOT_DIR /bin/bash << EOF
#########################################
# exit
cd /tmp/

error=0

for _block in $BLOCKLIST; do

	killall -9 jffs2_gcd_mtd5
	killall -9 jffs2_gcd_mtd6
	killall -9 jffs2_gcd_mtd7

# 	echo FLASHING BLOCK \$_block
	#we repeat it
	for attempt in 1 2 3; do
		mtdblock=mtdblock\$_block
		echo "Flashing now \$mtdblock <br>"
		
		#TODO: is there a way to use a variable as index? case statement is a workaround
		case \$_block in
			7)
				expected_md5sum=${check_md5sums[7]}
				;;
			6)
				expected_md5sum=${check_md5sums[6]}
				;;
			5)
				expected_md5sum=${check_md5sums[5]}
				;;
		esac
		
		echo "time tar xOzf $TARNAME_CHROOT \$mtdblock | dd of=/dev/\$mtdblock bs=1024k<br>"
		time tar xOzf $TARNAME_CHROOT \$mtdblock | dd of=/dev/\$mtdblock bs=1024k
	
		block2_md5sum=\$(md5sum /dev/\$mtdblock|sed 's/ .*//')
		
		if [[ \$expected_md5sum = \$block2_md5sum ]];then
			echo "md5sum of written partition \$mtdblock matches: \$block2_md5sum <br>" | tee -a $FLASH_LOG
			echo "========================================<br>"
			break
		else
			if [[ \$attempt = 3 ]]; then
				echo "md5sum mismatch of partition \$mtdblock<br>" | tee -a $FLASH_LOG
				echo "giving up, something went wrong<br>" | tee -a $FLASH_LOG
				echo "hope for the best!<br>" | tee -a $FLASH_LOG
				break
			else
				echo "md5sum mismatch of partition \$mtdblock in attempt \$attempt (got \$block2_md5sum, expected \$expected_md5sum), repeating writing of partition<br>" | tee -a $FLASH_LOG
			fi
		fi
	done
done

echo "#############################" >> $FLASH_LOG
echo Final check before reboot after flashing >> $FLASH_LOG
for _block in $BLOCKLIST; do
	echo "checking BLOCK \$_block <br>" | tee -a $FLASH_LOG
	md5sum /dev/mtdblock\$_block | tee -a $FLASH_LOG
	echo "<br>"
done
echo

echo -ne "<script>\nfunction load() {setTimeout(myURL, 120000);}\nfunction myURL() {window.open('../app/berogui/', name = self);}\nload();\n</script>\n"
echo "Rebooting now.<br>"| tee -a $FLASH_LOG
echo "<br><h1><font color='red'>Finished Successfully!<br>Rebooting now!</font></h1><br>"

echo Ended flash process: \$(date) >> $FLASH_LOG
rm -f $TARNAME_CHROOT
sync

if [[ -e /sys/class/beronet/fpga/reset ]]; then
	echo -ne "1" > /sys/class/beronet/fpga/reset
fi

/sbin/reboot
exit 0
EOF


#####################################################################
#####################################################################
##### image method
#####################################################################
#####################################################################

elif [[ $USE_IMAGE_FILES = 1 ]]; then


#copy the original md5 sums to the new tmp
for i in $BLOCKLIST; do
	cp -p /tmp/mtdblock$i.md5sum.1 $CHROOT_DIR/tmp/
done

create_mchroot_environment

/usr/sbin/chroot $CHROOT_DIR /bin/bash << EOF
#########################################

cd /tmp/
error=0

#actual download all needed blocks and write them to their partitions
for _block in $BLOCKLIST; do
	#we repeat it
	for attempt in 1 2 3; do
		block=mtdblock\$_block
		echo "==============================================================================================<br>" | tee -a $FLASH_LOG
		
		echo "<br>"
		echo "wget $IMAGE_URL/\$block -O /tmp/\$block <br>" | tee -a $FLASH_LOG
		wget $IMAGE_URL/\$block -O /tmp/\$block
		echo "<br>"
		
		check_blocksize \$block
		if [ \$error != 0 ]; then
			echo "fetching $IMAGE_URL/\$block failed <br>" | tee -a $FLASH_LOG
			exit 1
		fi
		
		#get the md5 file again
		echo "wget $IMAGE_URL/\$block.md5 -O /tmp/\$block.md5sum.2" | tee -a $FLASH_LOG
		echo "<br>"
		wget $IMAGE_URL/\$block.md5 -O /tmp/\$block.md5sum.2
		echo "<br>"
		
		file1_md5sum=\$(head -1 /tmp/\$block.md5sum.1|sed 's/ .*//')
		file2_md5sum=\$(head -1 /tmp/\$block.md5sum.2|sed 's/ .*//')
		block1_md5sum=\$(md5sum /tmp/\$block|sed 's/ .*//')
	
		echo file1_md5sum \$file1_md5sum >> $FLASH_LOG
		echo file2_md5sum \$file2_md5sum >> $FLASH_LOG
		echo block1_md5sum \$block1_md5sum >> $FLASH_LOG
	
		#check if its the same as in the first test
		if [[ \$file1_md5sum != \$file2_md5sum ]]; then
			echo "md5sum changed from first test<br>Cancelling process!<br>" | tee -a $FLASH_LOG
			exit 1
		fi
		
		#check if downloaded image matches
		if [[ \$block1_md5sum != \$file2_md5sum ]]; then
			echo "md5sum of image doesn't match!<br>Cancelling process!<br>" | tee -a $FLASH_LOG
			exit 1
		fi
		echo "<br>"
		
		echo "dd if=/tmp/\$block of=/dev/\$block bs=1024k <br>" | tee -a $FLASH_LOG
		time dd if=/tmp/\$block of=/dev/\$block bs=1024k
		echo "flashed \$block <br><br>" | tee -a $FLASH_LOG
		rm -f /tmp/\$block
		
		block2_md5sum=\$(md5sum /dev/\$block|sed 's/ .*//')
		echo block2_md5sum \$block1_md5sum >> $FLASH_LOG
		if [[ \$block2_md5sum = \$block2_md5sum ]];then
			echo "md5sum of written partition matches<br>" | tee -a $FLASH_LOG
			break
		else
			
			if [[ \$attempt = 3 ]]; then
				echo "md5sum mismatch of partition \$block<br>" | tee -a $FLASH_LOG
				echo "giving up, something went wrong<br>" | tee -a $FLASH_LOG
				echo "hope for the best!<br>" | tee -a $FLASH_LOG
				break
			else
				echo "md5sum mismatch of partition \$block in attempt \$attempt, repeating writing of partition<br>" | tee -a $FLASH_LOG
			fi
		fi
	done
done

echo -ne "<script>\nfunction load() {setTimeout(myURL, 120000);}\nfunction myURL() {window.open('../app/berogui/', name = self);}\nload();\n</script>\n"
echo "Rebooting now.<br>"| tee -a $FLASH_LOG
echo "<br><h1><font color='red'>Finished Successfully!<br>Rebooting now!</font></h1><br>"

echo Ended flash process: \$(date) >> $FLASH_LOG
/sbin/reboot

EOF

fi

echo "ddflash.sh ended <br>"


